#include <iostream>
#include <algorithm>

int matrica[1500][1500];
int matrica2[1500][1500];
int N, M;

void ispis(){
    std::cout << "---\n";
    for (int x = 0; x < N; x++){
        for (int y = 0; y < M; y++)
            std::cout << matrica[x][y] << " ";
        std::cout << "\n";
    }
    std::cout << "---\n";
}

struct upit{
    int x, y, k;
    upit(int ax, int ay){
        x = ax;
        y = ay;
    }
    upit() {}
    operator< (const upit& rhs){
        return k < rhs.k;
    }
};

void ispis_upit(upit* niz, int N){
    std::cout << "---\n";
    for (int i = 0; i < N; i++){
        std::cout << niz[i].x << " " << niz[i].y << " " << niz[i].k << " " << (1 << niz[i].k) << "\n";
    }
    std::cout << "---\n";
}

int amatrica(int x, int y){
    int ix = x, iy = y;
    if (x == -1) ix = N - 1;
    else if (x == N) ix = 0;
    if (y == -1) iy = M - 1;
    else if (y == M) iy = 0;
    return matrica[ix][iy];
}

int main(){

    int Q;
    std::cin >> N >> M >> Q;

    for (int x = 0; x < N; x++)
        for (int y = 0; y < M; y++)
            std::cin >> matrica[x][y];

    upit* upiti = new upit[Q];
    for (int i = 0; i < Q; i++) std::cin >> upiti[i].x >> upiti[i].y >> upiti[i].k;

    std::sort(upiti, upiti + Q);

    //ispis_upit(upiti, Q);

    int cur_index = 0;
    for (int t = 1; t <= 1 << upiti[Q-1].k; t++){
        for (int x = 0; x < N; x++)
            for (int y = 0; y < M; y++)
                matrica2[x][y] = amatrica(x - 1, y) ^ amatrica(x + 1, y) ^ amatrica(x, y - 1) ^ amatrica(x, y + 1);

        memcpy(matrica, matrica2, sizeof(matrica));

        if (t == 1 << upiti[cur_index].k){
            //ispis();
            std::cout << matrica[upiti[cur_index].x - 1][upiti[cur_index].y - 1] << "\n";
            cur_index++;
        }
    }

    /*
    ispis();

    while(!std::cin.eof()){
        char x; std::cin >> x;

        for (int x = 0; x < N; x++)
            for (int y = 0; y < M; y++)
                matrica2[x][y] = amatrica(x - 1, y) ^ amatrica(x + 1, y) ^ amatrica(x, y - 1) ^ amatrica(x, y + 1);

        memcpy(matrica, matrica2, sizeof(matrica));

        ispis();
    }
    //*/

    return 0;
}